﻿using System;
using System.Web.Mvc;
using System.Linq;
using MVC_App.Models;
using MVC_App.Validation;

namespace MVC_App.Controllers
{
	public class HomeController : Controller
	{
		[HttpGet]
		public ActionResult EditOrder()
		{
			return View(BuildDummyBestellung());
		}

		static BestellungForm BuildDummyBestellung()
		{
			return new BestellungForm
					{
						Lieferadresse = new LieferadresseForm(),
						Kreditkarte = new KreditkarteForm(),
						Pizza = new PizzaForm
											{
												Größe = PizzaGrößen.Mittel,
											}
					};
		}

		[HttpPost]
		public ActionResult SubmitOrder(BestellungForm bestellung)
		{
			CheckLieferzeitpunkt(bestellung);

			if (ModelState.IsValid)
			{
				// TODO: Ergebnisse verarbeiten
				return View("Success");
			}

			return View("EditOrder", bestellung);
		}

		private void CheckLieferzeitpunkt(BestellungForm bestellung)
		{
			switch (bestellung.LieferzeitpunktArt)
			{
				case Lieferzeitpunkte.Sofort:
					break;
				case Lieferzeitpunkte.Heute:
					if (bestellung.Lieferzeitpunkt.Uhrzeit == null)
						ModelState.AddModelError("Lieferzeitpunkt.Uhrzeit", "Bitte geben Sie eine gültige Uhrzeit für die Lieferung an.");
					break;
				case Lieferzeitpunkte.Am:
					if (bestellung.Lieferzeitpunkt.Uhrzeit == null)
						ModelState.AddModelError("Lieferzeitpunkt.Uhrzeit", "Bitte geben Sie eine gültige Uhrzeit für die Lieferung an.");
					if (bestellung.Lieferzeitpunkt.Datum == null)
						ModelState.AddModelError("Lieferzeitpunkt.Datum", "Bitte geben Sie ein gültiges Datum für die Lieferung an.");
					break;
				default:
					throw new ArgumentOutOfRangeException();
			}
		}
	}
}
